﻿QIPortalAPI.CategoryNode = function (ICU, CollapsedClass, ExpandedClass, CollapsedUrl, ExpandedUrl, text) {
    var BICU = ICU + 'b';

    var Div = document.querySelector('[NodeId="' + ICU + '"]');
    var Button = document.querySelector('[NodeId="' + BICU + '"]');
    if (Button !== null) {

        Button.classList.add("collapseButtonClass");
        Button.addEventListener("click", handleClick);
        if (isExpanded(Div)) {
            Div.classList.remove(CollapsedClass);
            if (text.length > 0) {
                Button.style.transform = 'rotate(90deg)';
            } else {
                Button.src = CollapsedUrl;
            }
        } else {
            Div.classList.add(CollapsedClass);
            if (text.length > 0) {
                Button.style.transform = 'rotate(0deg)';
            } else {
                Button.src = ExpandedUrl;
            }
        }
    } else {
        return;
    }

    function handleClick() {
        Collapse(Div);
    }

    function isCollapsed(element) {
        if (element.classList.contains(CollapsedClass)) {
            return true;
        }
        return false;
    }

    function isExpanded(element) {
        if (element.classList.contains(ExpandedClass)) {
            return true;
        }
        return false;
    }

    function Collapse(element) {
        if (isCollapsed(element)) {
            element.classList.remove(CollapsedClass);
            element.classList.add(ExpandedClass);
            if (text.length > 0) {
                Button.style.transform = 'rotate(90deg)';
            } else {
                Button.src = CollapsedUrl;
            }
        } else {
            element.classList.add(CollapsedClass);
            element.classList.remove(ExpandedClass);
            if (text.length > 0) {
                Button.style.transform = 'rotate(0deg)';
            } else {
                Button.src = ExpandedUrl;
            }
        }
   }
}
